/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.ws.listener.utils.WSListenerProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWWSPanel
extends VWTaskTabPanel {
    VWManagerNode m_node = null;
    private static final String P8BPMWSBROKER = "/P8BPMWSBroker";
    private static final String[] wsListenerPropertyNames = new String[]{"listener.base.url", "listener.local.host", "filenet.ws.request.concurrent.threads"};
    private static final String SAMPLE_LISTENER_URL = "http://host:###/Workplace";
    private static final String SAMPLE_LOCAL_HOST = "host:###";
    JTextField m_listenerURL = null;
    JTextField m_listenerLocalHost = null;
    JTextField m_concurrentThread = null;

    public VWWSPanel(VWManagerNode node) {
        this.m_node = node;
        this.initLayout();
    }

    private void getAValidConcurrentThread() {
        String pValue = null;
        WSListenerProperties props = this.m_node.getWSListenerProperties();
        pValue = props != null ? VWWSPanel.trim(props.getProperty(wsListenerPropertyNames[2])) : "1";
        this.m_concurrentThread.setText(pValue);
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
    }

    private String getAValidListenerURL() {
        int i;
        String pValue;
        String url = VWWSPanel.trim(this.m_listenerURL.getText());
        if (url != null && url.equals(SAMPLE_LISTENER_URL)) {
            url = null;
        }
        if (url != null) {
            return url;
        }
        WSListenerProperties props = this.m_node.getWSListenerProperties();
        if (props != null && (pValue = VWWSPanel.trim(props.getProperty(wsListenerPropertyNames[0]))) != null && (i = pValue.indexOf(P8BPMWSBROKER)) > 0) {
            url = pValue.substring(0, i);
        }
        if (url == null) {
            url = SAMPLE_LISTENER_URL;
        }
        this.m_listenerURL.setText(url);
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
        return url;
    }

    private static String trim(String s) {
        if (s != null) {
            if (s.trim().length() == 0) {
                return null;
            }
            return s.trim();
        }
        return s;
    }

    private void getAValidListenerLocalHost() {
        String s = VWWSPanel.trim(this.m_listenerLocalHost.getText());
        if (s != null && s.equals(SAMPLE_LOCAL_HOST)) {
            s = null;
        }
        if (s != null) {
            return;
        }
        String pValue = null;
        WSListenerProperties props = this.m_node.getWSListenerProperties();
        pValue = props != null ? VWWSPanel.trim(props.getProperty(wsListenerPropertyNames[1])) : null;
        s = pValue == null ? WSListenerProperties.getLocalListenerHost(this.m_listenerURL.getText()) : pValue;
        if (s == null) {
            s = SAMPLE_LOCAL_HOST;
        }
        this.m_listenerLocalHost.setText(s);
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
    }

    public void validateTextFields() throws VWException {
        String url = this.getAValidListenerURL();
        if (url.equals(SAMPLE_LISTENER_URL)) {
            VWException vwe = new VWException("ws.onlySampleNotValid", "{0} is only a sample for the input format, not valid for the actual value.", new Object[]{url});
            throw vwe;
        }
        try {
            new URL(url);
        }
        catch (Exception e) {
            VWException vwe = new VWException("ws.notValidURL", "{0} is not a valid URL.", new Object[]{url});
            throw vwe;
        }
        this.getAValidListenerLocalHost();
    }

    protected void applyProperties() {
        try {
            WSListenerProperties props = this.m_node.getWSListenerProperties();
            if (props == null) {
                return;
            }
            String s = this.getAValidListenerURL() + P8BPMWSBROKER;
            props.setProperties(wsListenerPropertyNames, new String[]{s, this.m_listenerLocalHost.getText().trim(), this.m_concurrentThread.getText().trim()}, true);
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while applying properties to WSListenerProperties.");
        }
    }

    protected void resetProperties() {
        try {
            this.getAValidListenerURL();
            this.getAValidListenerLocalHost();
            this.getAValidConcurrentThread();
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while re-getting properties from WSListenerProperties.");
        }
    }

    protected void updateState(boolean enabled) {
        this.m_listenerURL.setEditable(enabled);
        this.m_listenerLocalHost.setEditable(enabled);
        this.m_concurrentThread.setEditable(enabled);
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 5, 5);
        this.m_listenerURL = new JTextField("");
        this.m_listenerURL.setName(VWResource.WSListenerURL);
        this.m_listenerURL.addFocusListener(this);
        this.add((Component)new JLabel(this.m_listenerURL.getName() + ":"), c);
        ++c.gridy;
        this.m_listenerLocalHost = new JTextField("");
        this.m_listenerLocalHost.setName(VWResource.WSListenerLocalHost);
        this.m_listenerLocalHost.addFocusListener(this);
        this.add((Component)new JLabel(this.m_listenerLocalHost.getName() + ":"), c);
        ++c.gridy;
        this.m_concurrentThread = new JTextField("");
        this.m_concurrentThread.setName(VWResource.WSRequestConcurrentThreads);
        this.m_concurrentThread.addFocusListener(this);
        this.add((Component)new JLabel(this.m_concurrentThread.getName() + ":"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((JTextComponent)this.m_listenerURL, (Object)c, false);
        ++c.gridy;
        this.add((JTextComponent)this.m_listenerLocalHost, (Object)c, false);
        ++c.gridy;
        this.add((JTextComponent)this.m_concurrentThread, (Object)c, false);
        this.resetProperties();
    }

    public String getHelpPage() {
        return VWHelp.Help_Process_TaskManager + "cm_config_ws.htm";
    }
}

